name = "Force Biomes"
author = "T Shaw Killer"
version = "1.1"
description = 
[[
Forces any optional biome to spawn during world generation.

Options:
On - Biome will spawn
Random - Biome might spawn (default)
Off - Biome will not spawn

Forest: 4 of 8 biomes spawn during normal forest gen. Recommend to force UP TO 4.
Forest RoG: 4 of 11 biomes spawn during normal forest gen. Recommend to force UP TO 4.
Cave: 2-3 of 7 biomes spawn during normal cave gen. Recommend to force UP TO 3.
Ruins: 1-2 of 7 biomes spawn during normal ruins gen. Recommend to force UP TO 2.
SW: Work in progress
]]
api_version = 6
dst_compatible = false
dont_starve_compatible = true
reign_of_giants_compatible = true
shipwrecked_compatible = true
forumthread = ""
icon_atlas = "biome.xml"
icon = "biome.tex"

local biome_options = {
	{ description = "Off", 		data = "OFF" },
	{ description = "Random",	data = "RANDOM" },
	{ description = "On", 		data = "ON" }
}
local default_random = "RANDOM"
local null_options = {
	{ description = "\n", data = 0 }
}

configuration_options =
{
	{
		name = "null",
		label = "Forest Biomes",
		options = null_options,
		default = 0,
		hover = "Biomes below are for the forest (surface)"
	},
	{
		name = "BEFRIENDTHEPIGS",
		label = "Pig Village",
		options = biome_options,
		default = default_random,
		hover = "Adds the Pig Village biome to world generation"
	},
	{
		name = "FORANICEWALK",
		label = "Mandrake Forest",
		options = biome_options,
		default = default_random,
		hover = "Adds the Mandrake Forest biome to world generation"
	},
	{
		name = "KILLTHESPIDERS",
		label = "Spider Quarry",
		options = biome_options,
		default = default_random,
		hover = "Adds the Spider Quarry biome to world generation"
	},
	{
		name = "KILLERBEES",
		label = "Killer Bees",
		options = biome_options,
		default = default_random,
		hover = "Adds the Killer Bees biome to world generation"
	},
	{
		name = "MAKEABEEHAT",
		label = "Flower Patch and Rocks",
		options = biome_options,
		default = default_random,
		hover = "Adds the Flower Patch and Rocks biome to world generation"
	},
	{
		name = "THEHUNTERS",
		label = "Triple MacTusk",
		options = biome_options,
		default = default_random,
		hover = "Adds the Triple MacTusk biome to world generation"
	},
	{
		name = "MAGICMEADOW",
		label = "Frog Ponds",
		options = biome_options,
		default = default_random,
		hover = "Adds the Frog Ponds biome to world generation"
	},
	{
		name = "FROGSANDBUGS",
		label = "Frogs and Bugs",
		options = biome_options,
		default = default_random,
		hover = "Adds the Frogs and Bugs biome to world generation"
	},
	{
		name = "null",
		label = "Reign of Giants",
		options = null_options,
		default = 0,
		hover = "Only active on worlds with RoG enabled",
	},
	{
		name = "OASIS",
		label = "Oasis",
		options = biome_options,
		default = default_random,
		hover = "Adds the Oasis biome to world generation"
	},
	{
		name = "MOLECOLONYDECIDUOUS",
		label = "Extra Deciduous",
		options = biome_options,
		default = default_random,
		hover = "Adds the Extra Deciduous biome to world generation"
	},
	{
		name = "MOLECOLONYROCKS",
		label = "Rocky",
		options = biome_options,
		default = default_random,
		hover = "Adds the Rocky biome to world generation"
	},
	{
		name = "null",
		label = "\n",
		options = null_options,
		default = 0,
		hover = "\n",
	},
	{
		name = "null",
		label = "Cave Biomes",
		options = null_options,
		default = 0,
		hover = "Biomes below are for the caves"
	},
	{
		name = "CAVEBASE",
		label = "Cave Base",
		options = biome_options,
		default = default_random,
		hover = "Adds the Cave Base biome to world generation"
	},
	{
		name = "MUSHBASE",
		label = "Mush Base",
		options = biome_options,
		default = default_random,
		hover = "Adds the Mush Base biome to world generation"
	},
	{
		name = "SINKBASE",
		label = "Sink Base",
		options = biome_options,
		default = default_random,
		hover = "Adds the Sink Base biome to world generation"
	},
	{
		name = "RABBITTOWN",
		label = "Rabbit Town",
		options = biome_options,
		default = default_random,
		hover = "Adds the Rabbit Town biome to world generation"
	},
	{
		name = "REDFUNGALCOMPLEX",
		label = "Red Mushroom and Bat Cave",
		options = biome_options,
		default = default_random,
		hover = "Adds the Red Mushroom and Bat Cave biome to world generation"
	},
	{
		name = "GREENFUNGALCOMPLEX",
		label = "Green Mushroom and Bat Cave",
		options = biome_options,
		default = default_random,
		hover = "Adds the Green Mushroom and Bat Cave biome to world generation"
	},
	{
		name = "BLUEFUNGALCOMPLEX",
		label = "Blue Mushroom and Bat Cave",
		options = biome_options,
		default = default_random,
		hover = "Adds the Blue Mushroom and Bat Cave biome to world generation"
	},
	{
		name = "null",
		label = "\n",
		options = null_options,
		default = 0,
		hover = "\n",
	},
	{
		name = "null",
		label = "Ruins Biomes",
		options = null_options,
		default = 0,
		hover = "Biomes below are for the ruins"
	},
	{
		name = "MOREALTARS",
		label = "More Altars",
		options = biome_options,
		default = default_random,
		hover = "Adds the More Altars biome to world generation"
	},
	{
		name = "SACREDDANGER",
		label = "Sacred Danger",
		options = biome_options,
		default = default_random,
		hover = "Adds the Sacred Danger biome to world generation"
	},
	{
		name = "FAILEDCAMP",
		label = "Ruins Camp",
		options = biome_options,
		default = default_random,
		hover = "Adds the Ruins Camp biome to world generation"
	},
	{
		name = "RESIDENTIAL2",
		label = "Village and Cave Jungle",
		options = biome_options,
		default = default_random,
		hover = "Adds the Village and Cave Jungle biome to world generation"
	},
	{
		name = "RESIDENTIAL3",
		label = "Village Houses",
		options = biome_options,
		default = default_random,
		hover = "Adds the Village Houses biome to world generation"
	},
	{
		name = "MILITARY2",
		label = "Extra Military",
		options = biome_options,
		default = default_random,
		hover = "Adds the Extra Military biome to world generation"
	},
	{
		name = "SACRED2",
		label = "Extra Sacred",
		options = biome_options,
		default = default_random,
		hover = "Adds the Extra Sacred biome to world generation"
	}
}